/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWConfigUDDIRegistryListTableModel
extends AbstractTableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_INQUIRY_URL = 1;
    public static final int COLUMN_PUBLISH = 2;
    public static final int COLUMN_PUBLISH_URL = 3;
    public static final int COLUMN_BUSINESS_NAME = 4;
    protected Frame m_parentFrame = null;
    protected String m_dialogTitle = null;
    private Vector m_rowData = null;
    private boolean m_bHasChanged = false;
    private String[] m_columnName = new String[]{VWResource.Name, VWResource.InquiryURL, "", VWResource.PublishURL, VWResource.BusinessName};

    public VWConfigUDDIRegistryListTableModel(Frame parentFrame, VWUDDIRegistry[] vwUDDIRegistrylist) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_rowData = new Vector();
            if (vwUDDIRegistrylist != null) {
                for (int i = 0; i < vwUDDIRegistrylist.length; ++i) {
                    this.m_rowData.add(vwUDDIRegistrylist[i]);
                }
            }
            this.m_dialogTitle = VWIDMBaseFactory.instance().getVWString(4).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWUDDIRegistry[] getUDDIRegistries() {
        Object[] theList = new VWUDDIRegistry[this.m_rowData.size()];
        this.m_rowData.copyInto(theList);
        return theList;
    }

    public void addRow() {
        try {
            if (this.m_rowData == null) {
                this.m_rowData = new Vector();
            }
            VWUDDIRegistry uddiRegistry = new VWUDDIRegistry();
            VWUDDIBusinessEntity vwBusinessEntity = new VWUDDIBusinessEntity();
            uddiRegistry.addBusinessEntity(vwBusinessEntity);
            this.m_rowData.addElement(uddiRegistry);
            int nRow = this.m_rowData.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
            this.m_bHasChanged = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_rowData == null || nRow < 0 || nRow >= this.m_rowData.size()) {
                return;
            }
            VWUDDIRegistry rowItem = (VWUDDIRegistry)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                this.m_rowData.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
                this.m_bHasChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void validateRow(int nRow) {
        try {
            if (this.m_rowData == null) {
                return;
            }
            String msg = null;
            VWUDDIRegistry rowItem = (VWUDDIRegistry)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                String publishURL;
                msg = this.checkDuplicateName(rowItem.getName(), nRow);
                if (msg != null && msg.length() > 0) {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, this.m_dialogTitle, 1);
                    return;
                }
                String inquiryURL = rowItem.getInquiryURL();
                if (inquiryURL == null || inquiryURL.length() < 1) {
                    msg = VWResource.MissingUDDIRegInquiryURL.toString(String.valueOf(nRow + 1));
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, this.m_dialogTitle, 1);
                    return;
                }
                if (rowItem.getPublish() && ((publishURL = rowItem.getPublishURL()) == null || publishURL.length() < 1)) {
                    msg = VWResource.MissingUDDIRegPublishURL.toString(String.valueOf(nRow + 1));
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, this.m_dialogTitle, 1);
                    return;
                }
                msg = rowItem.validateUDDI();
                if (msg != null && msg.length() > 0) {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.InvalidUDDIRegistry.toString(rowItem.getName(), msg, String.valueOf(nRow + 1)), this.m_dialogTitle, 3);
                } else {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.ValidationIsSuccess, this.m_dialogTitle, 2);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public boolean verifyUDDIRegistries() {
        try {
            if (this.m_rowData == null) {
                return true;
            }
            int rowCount = this.m_rowData.size();
            for (int i = rowCount - 1; i >= 0; --i) {
                String publishURL;
                VWUDDIRegistry rowItem = (VWUDDIRegistry)this.m_rowData.elementAt(i);
                String msg = null;
                String uddiName = rowItem.getName();
                if (uddiName == null || uddiName.length() < 1) {
                    msg = VWResource.s_missingUDDIRegName.toString(String.valueOf(i + 1));
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, this.m_dialogTitle, 1);
                    return false;
                }
                String inquiryURL = rowItem.getInquiryURL();
                if (inquiryURL == null || inquiryURL.length() < 1) {
                    msg = VWResource.MissingUDDIRegInquiryURL.toString(String.valueOf(i + 1));
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, this.m_dialogTitle, 1);
                    return false;
                }
                if (rowItem.getPublish() && ((publishURL = rowItem.getPublishURL()) == null || publishURL.length() < 1)) {
                    msg = VWResource.MissingUDDIRegPublishURL.toString(String.valueOf(i + 1));
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, this.m_dialogTitle, 1);
                    return false;
                }
                msg = this.checkDuplicateName(uddiName, i);
                if (msg != null && msg.length() > 0) {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, this.m_dialogTitle, 1);
                    return false;
                }
                msg = rowItem.validateUDDI();
                if (msg == null || msg.length() <= 0) continue;
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.InvalidUDDIRegistry.toString(rowItem.getName(), msg, String.valueOf(i + 1)), this.m_dialogTitle, 1);
                return false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_columnName.length;
    }

    public String getColumnName(int nColumn) {
        if (nColumn < 0 || nColumn > this.m_columnName.length) {
            return null;
        }
        return this.m_columnName[nColumn];
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return null;
            }
            VWUDDIRegistry oUDDIRegistry = (VWUDDIRegistry)this.m_rowData.elementAt(nRowIndex);
            if (oUDDIRegistry == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return oUDDIRegistry.getName();
                }
                case 3: {
                    String publishedURL = oUDDIRegistry.getPublishURL();
                    if (publishedURL == null) {
                        publishedURL = "";
                    }
                    return publishedURL;
                }
                case 1: {
                    String inquiryURL = oUDDIRegistry.getInquiryURL();
                    if (inquiryURL == null) {
                        inquiryURL = "";
                    }
                    return inquiryURL;
                }
                case 2: {
                    return new Boolean(oUDDIRegistry.getPublish());
                }
                case 4: {
                    String businessName = oUDDIRegistry.getBusinessName();
                    if (businessName == null) {
                        businessName = "";
                    }
                    return businessName.trim();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        VWUDDIBusinessEntity vwBn;
        String businessKey;
        boolean bEditable = true;
        if (nColumn != 2 && (businessKey = (vwBn = this.getBusinessEntity(nRow)).getBusinessKey()) != null && businessKey.length() > 0) {
            bEditable = false;
        }
        return bEditable;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return;
            }
            VWUDDIRegistry oUDDIRegistry = (VWUDDIRegistry)this.m_rowData.elementAt(nRowIndex);
            if (oUDDIRegistry == null) {
                return;
            }
            switch (nColumnIndex) {
                case 0: {
                    oUDDIRegistry.setName((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 3: {
                    oUDDIRegistry.setPublishURL((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 1: {
                    oUDDIRegistry.setInquiryURL((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 2: {
                    Boolean bPublish = (Boolean)aValue;
                    oUDDIRegistry.setPublish(bPublish);
                    this.m_bHasChanged = true;
                    break;
                }
                case 4: {
                    String businessName = (String)aValue;
                    if (businessName == null || businessName.trim().length() <= 0) {
                        oUDDIRegistry.removeBusinessAt(0);
                    } else {
                        oUDDIRegistry.setBusinessName(((String)aValue).trim());
                    }
                    this.m_bHasChanged = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isPublishEnabled(int rowIndex) {
        boolean bEnabled = false;
        if (rowIndex >= 0 || rowIndex < this.m_rowData.size()) {
            VWUDDIRegistry vwUDDIRegistry = (VWUDDIRegistry)this.m_rowData.elementAt(rowIndex);
            bEnabled = vwUDDIRegistry.getPublish();
        }
        return bEnabled;
    }

    public String getPublishURL(int rowIndex) {
        String publishURL = null;
        if (rowIndex >= 0 || rowIndex < this.m_rowData.size()) {
            VWUDDIRegistry vwUDDIRegistry = (VWUDDIRegistry)this.m_rowData.elementAt(rowIndex);
            publishURL = vwUDDIRegistry.getPublishURL();
        }
        return publishURL;
    }

    public VWUDDIRegistry getVWUDDIRegistry(int rowIndex) {
        VWUDDIRegistry vwUDDIRegistry = null;
        if (rowIndex >= 0 || rowIndex < this.m_rowData.size()) {
            vwUDDIRegistry = (VWUDDIRegistry)this.m_rowData.elementAt(rowIndex);
        }
        return vwUDDIRegistry;
    }

    public VWUDDIBusinessEntity getBusinessEntity(int rowIndex) {
        VWUDDIRegistry vwUDDIRegistry;
        VWUDDIBusinessEntity vwBusinessEntity = null;
        if ((rowIndex >= 0 || rowIndex < this.m_rowData.size()) && (vwBusinessEntity = (vwUDDIRegistry = (VWUDDIRegistry)this.m_rowData.elementAt(rowIndex)).getVWBusinessEntity(0)) == null) {
            vwBusinessEntity = new VWUDDIBusinessEntity();
            vwUDDIRegistry.addBusinessEntity(vwBusinessEntity);
        }
        return vwBusinessEntity;
    }

    public void setBusinessEntity(int rowIndex, VWUDDIBusinessEntity vwBusinessEntity) {
        VWUDDIRegistry vwUDDIRegistry;
        if ((rowIndex >= 0 || rowIndex < this.m_rowData.size()) && (vwUDDIRegistry = (VWUDDIRegistry)this.m_rowData.elementAt(rowIndex)) != null) {
            vwUDDIRegistry.setVWBusinessEntity(0, vwBusinessEntity);
            this.m_rowData.setElementAt(vwUDDIRegistry, rowIndex);
            this.m_bHasChanged = true;
            this.fireTableDataChanged();
        }
    }

    public void releaseResources() {
        this.m_dialogTitle = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
    }

    private String checkDuplicateName(String uddiName, int row) {
        String msg = null;
        if (uddiName == null || uddiName.trim().length() < 1) {
            msg = VWResource.s_missingUDDIRegName.toString(String.valueOf(row + 1));
            return msg;
        }
        int rowCount = this.m_rowData.size();
        for (int i = 0; i < rowCount; ++i) {
            if (i == row) continue;
            VWUDDIRegistry uddiReg = (VWUDDIRegistry)this.m_rowData.elementAt(i);
            String urName = uddiReg.getName();
            if (urName == null || urName.length() < 1) {
                msg = VWResource.s_missingUDDIRegName.toString(String.valueOf(i + 1));
                break;
            }
            if (uddiName.compareTo(urName) != 0) continue;
            msg = VWResource.DuplicatedUDDIRegistryName.toString(uddiName, String.valueOf(i + 1), String.valueOf(row + 1));
            break;
        }
        return msg;
    }
}

